package com.smart.nfcreader.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import java.util.List;

public class INfcManager {

    private NfcAdapter mNfcAdapter;
    private PendingIntent mPendingIntent;

    private ResolveNfc resolveNfc;

    public INfcManager(Context context, Class clazz) {
        //初始化nfc
        mNfcAdapter = NfcAdapter.getDefaultAdapter(context);
        mPendingIntent = PendingIntent.getActivity(context, 0,
                new Intent(context, clazz).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
    }

    public boolean isEnable() {
        return mNfcAdapter != null && mNfcAdapter.isEnabled();
    }

    public void setResolveNfc(ResolveNfc resolveNfc) {
        this.resolveNfc = resolveNfc;
    }


    public void registerDispatch(Activity activity) {
        mNfcAdapter.enableForegroundDispatch(activity, mPendingIntent, null, null);
    }

    public void unRegisterDispatch(Activity activity) {
        mNfcAdapter.disableForegroundDispatch(activity);
    }

    /**
     * 初次判断是什么类型的NFC卡
     *
     * @param intent 解析Nfc内容
     */
    public void resolve(Intent intent) {

        if (intent == null) {
            return;
        }

        //解析NFC数据
        NdefMessage[] msgs = NfcUtil.getNdefMessage(intent);
        if (msgs != null) {
            setNfcMessage(msgs);
        }
    }

    /**
     * 显示扫描后的信息
     *
     * @param ndefMessages ndef数据
     */
    private void setNfcMessage(NdefMessage[] ndefMessages) {
        if (ndefMessages == null || ndefMessages.length == 0) {
            return;
        }
        List<ParsedNdefRecord> records = NdefMessageParser.parse(ndefMessages[0]);
        final int size = records.size();
        for (int i = 0; i < size; i++) {
            byte[] payload = ndefMessages[0].getRecords()[i].getPayload();
            int length = payload[0] + payload[1] * 256;
            if (length == payload.length) {
                byte[] address = new byte[6];
                if (length > 12) {
                    //读取蓝牙mac地址
                    for (int j = 7; j >= 2; j--) {
                        address[7 - j] = payload[j];
                    }
                    String macAddress = byte2MacAddress(address);
                    //读取蓝牙名称
                    StringBuffer name = new StringBuffer();
                    for (int j = 10; j <length ; j++) {
                        if(payload[j] == 0x04)
                            break;
                        char c = (char) payload[j];
                        name.append(c);
                    }
                    if (resolveNfc != null) {
                        resolveNfc.onNfcResult(macAddress, name.toString());
                    }
                }
            }
        }
    }

    /**
     * byte转ASCII mac地址
     *
     * @param b
     * @return
     */
    private static String byte2MacAddress(byte[] b) {
        StringBuilder macStr = new StringBuilder();

        for (int i = 0; i < b.length; i++) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            macStr.append(hex.toUpperCase()).append(i == b.length - 1 ? "" : ":");
        }

        return macStr.toString();
    }

    public interface ResolveNfc {

        /**
         * @param address 蓝牙mac地址
         */
        void onNfcResult(String address, String name);
    }
}
